/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.RenderType;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class AutoRangeUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.ops.autorange");

    private static void setRange(DDataSet range, DatumRange drange, boolean log) {
        range.putProperty("UNITS", (Object)drange.getUnits());
        range.putValue(0, drange.min().doubleValue(drange.getUnits()));
        range.putValue(1, drange.max().doubleValue(drange.getUnits()));
        if (log) {
            range.putProperty("SCALE_TYPE", (Object)"log");
        }
    }

    private static double[] simpleRange(QDataSet ds) {
        QDataSet delta;
        logger.entering("org.autoplot.AutoRangeUtil", "simpleRange", ds);
        QDataSet max = ds;
        QDataSet min = ds;
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((delta = (QDataSet)ds.property("DELTA_PLUS")) != null) {
            max = Ops.add((QDataSet)ds, (QDataSet)delta);
        } else {
            delta = (QDataSet)ds.property("BIN_PLUS");
            if (delta != null) {
                max = Ops.add((QDataSet)ds, (QDataSet)delta);
            }
        }
        delta = (QDataSet)ds.property("DELTA_MINUS");
        if (delta != null) {
            min = Ops.subtract((QDataSet)ds, (QDataSet)delta);
        } else {
            delta = (QDataSet)ds.property("BIN_MINUS");
            if (delta != null) {
                min = Ops.subtract((QDataSet)ds, (QDataSet)delta);
            }
        }
        QDataSet wmin = DataSetUtil.weightsDataSet((QDataSet)min);
        QDataSet wmax = DataSetUtil.weightsDataSet((QDataSet)max);
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds);
        double[] result = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        if (ds.rank() == 1) {
            int n0 = Math.min(ds.length(), 10000000);
            for (int i = 0; i < n0; ++i) {
                double maxv;
                if (wds.value(i) == 0.0 || Double.isInfinite(maxv = max.value(i))) continue;
                if (wmin.value(i) > 0.0) {
                    result[0] = Math.min(result[0], min.value(i));
                }
                if (!(wmax.value(i) > 0.0)) continue;
                result[1] = Math.max(result[1], maxv);
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            int i = 0;
            while (i < 10000000 && it.hasNext()) {
                double maxv;
                it.next();
                ++i;
                if (it.getValue(wds) == 0.0 || Double.isInfinite(maxv = it.getValue(max))) continue;
                if (it.getValue(wmin) > 0.0) {
                    result[0] = Math.min(result[0], it.getValue(min));
                }
                if (!(it.getValue(wmax) > 0.0)) continue;
                result[1] = Math.max(result[1], maxv);
            }
        }
        if (result[0] == Double.POSITIVE_INFINITY) {
            if (UnitsUtil.isTimeLocation((Units)u)) {
                result[0] = Units.t2000.convertDoubleTo(u, 0.0);
                result[1] = Units.t2000.convertDoubleTo(u, 86400.0);
            } else {
                result[0] = 0.0;
                result[1] = 1.0;
            }
        }
        logger.exiting("org.autoplot.AutoRangeUtil", "simpleRange");
        return result;
    }

    public static AutoRangeDescriptor commonRange(List<AutoRangeDescriptor> adss) {
        AutoRangeDescriptor common = new AutoRangeDescriptor();
        common.range = null;
        common.log = true;
        for (AutoRangeDescriptor ads : adss) {
            if (common.range == null) {
                common.range = ads.range;
            }
            if (ads.log) continue;
            common.log = false;
        }
        return common;
    }

    private static DatumRange getRange(Number min, Number max, Units units) {
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            if (min == null) {
                min = Units.mj1958.convertDoubleTo(units, -100000.0);
            }
            if (max == null) {
                max = Units.mj1958.convertDoubleTo(units, 100000.0);
            }
        } else {
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            if (units == null) {
                units = Units.dimensionless;
            }
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            TimeLocationUnits tu = (TimeLocationUnits)units;
            if (!tu.isValid(min.doubleValue())) {
                min = tu.validMin();
            }
            if (!tu.isValid(max.doubleValue())) {
                max = tu.validMax();
            }
            return new DatumRange(min.doubleValue(), max.doubleValue(), units);
        }
        try {
            return new DatumRange(min.doubleValue(), max.doubleValue(), units);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("here here");
            throw ex;
        }
    }

    private static DatumRange makeDimensionless(DatumRange dr) {
        Units u = dr.getUnits();
        return new DatumRange(dr.min().doubleValue(u), dr.max().doubleValue(u), Units.dimensionless);
    }

    public static QDataSet bounds(QDataSet dataSet, RenderType renderType) throws Exception {
        AutoRangeDescriptor xdesc;
        DDataSet xrange = DDataSet.createRank1((int)2);
        DDataSet yrange = DDataSet.createRank1((int)2);
        DDataSet zrange = DDataSet.createRank1((int)2);
        JoinDataSet result = new JoinDataSet(2);
        result.join((QDataSet)xrange);
        result.join((QDataSet)yrange);
        result.join((QDataSet)zrange);
        HashMap props = new HashMap();
        if (renderType == RenderType.spectrogram || renderType == RenderType.nnSpectrogram) {
            QDataSet xds = (QDataSet)dataSet.property("DEPEND_0");
            if (xds == null) {
                if (dataSet.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < dataSet.length(); ++i) {
                        ds.join((QDataSet)dataSet.property("DEPEND_0", i));
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet((int)dataSet.length());
                }
            }
            QDataSet yds = (QDataSet)dataSet.property("DEPEND_1");
            Map yprops = (Map)props.get("DEPEND_1");
            if (yds == null) {
                if (dataSet.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < dataSet.length(); ++i) {
                        ds.join((QDataSet)dataSet.property("DEPEND_1", i));
                    }
                    yds = ds;
                } else if (dataSet.rank() > 1) {
                    yds = DataSetUtil.indexGenDataSet((int)dataSet.length(0));
                } else {
                    yds = DataSetUtil.indexGenDataSet((int)10);
                    yprops = null;
                }
            }
            xdesc = AutoRangeUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            AutoRangeDescriptor ydesc = AutoRangeUtil.autoRange(yds, yprops);
            AutoRangeDescriptor desc = AutoRangeUtil.autoRange(dataSet, props);
            AutoRangeUtil.setRange(zrange, desc.range, desc.log);
            AutoRangeUtil.setRange(xrange, xdesc.range, xdesc.log);
            AutoRangeUtil.setRange(yrange, ydesc.range, ydesc.log);
        } else {
            QDataSet depend0;
            AutoRangeDescriptor ydesc;
            if (SemanticOps.isBundle((QDataSet)dataSet)) {
                ydesc = AutoRangeUtil.autoRange(DataSetOps.unbundle((QDataSet)dataSet, (int)1), props);
                depend0 = DataSetOps.unbundle((QDataSet)dataSet, (int)0);
            } else {
                ydesc = AutoRangeUtil.autoRange(dataSet, props);
                depend0 = (QDataSet)dataSet.property("DEPEND_0");
            }
            AutoRangeUtil.setRange(yrange, ydesc.range, ydesc.log);
            QDataSet xds = depend0;
            if (xds == null) {
                xds = DataSetUtil.indexGenDataSet((int)dataSet.length());
            }
            xdesc = AutoRangeUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            AutoRangeUtil.setRange(xrange, xdesc.range, xdesc.log);
            if (renderType == RenderType.colorScatter) {
                AutoRangeDescriptor zdesc;
                if (dataSet.property("BUNDLE_1") != null) {
                    zdesc = AutoRangeUtil.autoRange(DataSetOps.unbundle((QDataSet)dataSet, (int)2), null);
                } else {
                    QDataSet plane0 = (QDataSet)dataSet.property("PLANE_0");
                    zdesc = AutoRangeUtil.autoRange(plane0, (Map)props.get("PLANE_0"));
                }
                AutoRangeUtil.setRange(zrange, zdesc.range, zdesc.log);
            }
        }
        for (int i = 0; i < result.length(); ++i) {
            Units u = (Units)result.property("UNITS", i);
            if (u != null) {
                DatumRange dr = DatumRange.newDatumRange((double)result.value(i, 0), (double)result.value(i, 1), (Units)u);
                logger.log(Level.FINER, "{0}: {1}", new Object[]{i, dr});
                continue;
            }
            logger.log(Level.FINER, "{0}: {1},{2}", new Object[]{i, result.value(i, 0), result.value(i, 1)});
        }
        return result;
    }

    public static AutoRangeDescriptor autoRange(QDataSet hist, QDataSet ds, Map properties) {
        double[] dd;
        Logger logger1 = LoggerManager.getLogger((String)"qdataset.ops.autorange");
        logger1.log(Level.FINE, "enter autoRange {0}", ds);
        logger1.entering("org.autoplot.AutoRangeUtil", "autoRange");
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        AutoRangeDescriptor result = new AutoRangeDescriptor();
        boolean mono = Boolean.TRUE.equals(ds.property("MONOTONIC")) || null != ds.property("CADENCE");
        long total = (Long)((Map)hist.property("USER_PROPERTIES")).get("total");
        double median = Double.NaN;
        if (mono) {
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)ds, null);
            if (cadence == null || cadence.value() > 1.7976931348623156E306) {
                cadence = DRank0DataSet.create((double)0.0);
            }
            if (ds.length() > 1) {
                double min = Math.min(ds.value(0), ds.value(ds.length() - 1));
                double max = Math.max(ds.value(0), ds.value(ds.length() - 1));
                double dcadence = Math.abs(cadence.value());
                if ("log".equals(cadence.property("SCALE_TYPE"))) {
                    Units cu = (Units)cadence.property("UNITS");
                    double factor = (cu.convertDoubleTo(Units.percentIncrease, dcadence) + 100.0) / 100.0;
                    dd = new double[]{min / factor, max * factor};
                } else {
                    dd = new double[]{min - dcadence, max + dcadence};
                }
            } else {
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
            median = (dd[0] + dd[1]) / 2.0;
        } else {
            dd = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
            QDataSet dep0 = (QDataSet)hist.property("DEPEND_0");
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)dep0, null);
            int tot = 0;
            for (int i = 0; i < hist.length(); ++i) {
                tot = (int)((double)tot + hist.value(i));
                if (dd[0] == Double.NEGATIVE_INFINITY && hist.value(i) > 0.0) {
                    dd[0] = dep0.value(i);
                }
                if (hist.value(i) > 0.0) {
                    dd[1] = dep0.value(i) + cadence.value();
                }
                if ((long)tot < total / 2L) continue;
                median = dep0.value(i);
            }
        }
        if (total < 3L) {
            result.median = median;
            result.range = DatumRange.newDatumRange((double)dd[0], (double)dd[1], (Units)u);
            result.robustMin = dd[0];
            result.robustMax = dd[1];
        } else {
            double clog;
            double nomMax;
            double nomMin;
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (mono) {
                nomMin = ds.value(0);
                nomMax = ds.value(ds.length() - 1);
            } else {
                nomMin = dd[0];
                nomMax = dd[1];
            }
            double clin = (nomMax - result.median) / (result.median - nomMin);
            if (clin > 1.0) {
                clin = 1.0 / clin;
            }
            if ((clog = nomMax / result.median / Math.abs(result.median / nomMin)) > 1.0) {
                clog = 1.0 / clog;
            }
            if (clog > clin && nomMax / nomMin > 100.0) {
                result.log = true;
            }
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        if ("log".equals(ds.property("SCALE_TYPE"))) {
            result.log = true;
        }
        if (properties != null) {
            String log1 = (String)properties.get("SCALE_TYPE");
            if (log1 != null) {
                result.log = log1.equals("log");
            }
            Number tmin = (Number)properties.get("TYPICAL_MIN");
            Number tmax = (Number)properties.get("TYPICAL_MAX");
            DatumRange range = AutoRangeUtil.getRange((Number)properties.get("TYPICAL_MIN"), (Number)properties.get("TYPICAL_MAX"), (Units)properties.get("UNITS"));
            if (tmin != null || tmax != null) {
                double d2;
                double d1;
                if (result.log) {
                    try {
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                        d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoRangeUtil.makeDimensionless(range);
                        result.range = AutoRangeUtil.makeDimensionless(result.range);
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                        d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                    }
                } else {
                    try {
                        d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                        d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoRangeUtil.makeDimensionless(range);
                        result.range = AutoRangeUtil.makeDimensionless(result.range);
                        d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                        d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                    }
                }
                if (d2 - d1 > 0.1 && d2 > 0.0 && d1 < 1.0) {
                    result.range = range;
                    logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange");
                    return result;
                }
            }
        }
        if (UnitsUtil.isRatioMeasurement((Units)u) || UnitsUtil.isIntervalMeasurement((Units)u)) {
            if (result.log) {
                if (result.robustMin <= 0.0) {
                    result.robustMin = result.robustMax / 1000.0;
                }
                result.range = DatumRange.newDatumRange((double)Math.pow(10.0, Math.floor(Math.log10(result.robustMin))), (double)Math.pow(10.0, Math.ceil(Math.log10(result.robustMax))), (Units)u);
            } else {
                result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
                if (result.robustMin < result.robustMax) {
                    result.range = DatumRangeUtil.rescale((DatumRange)result.range, (double)-0.05, (double)1.05);
                }
                if (result.robustMin == 0.0 && result.robustMax == 0.0) {
                    result.range = DatumRange.newDatumRange((double)-0.1, (double)1.0, (Units)u);
                }
            }
        } else {
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange");
        return result;
    }

    public static AutoRangeDescriptor autoRange(QDataSet ds, Map properties) {
        return AutoRangeUtil.autoRange(ds, properties, false);
    }

    public static AutoRangeDescriptor autoRange(QDataSet ds, Map properties, boolean ignoreDsProps) {
        int total;
        double positiveMin;
        double median;
        double[] dd;
        boolean isLin;
        Logger logger1 = LoggerManager.getLogger((String)"qdataset.ops.autorange");
        logger1.entering("org.autoplot.AutoRangeUtil", "autoRange", ds);
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            if (ds.property("JOIN_0") != null) {
                if (ds.length() == 0) {
                    throw new IllegalArgumentException("dataset is empty");
                }
                u = (Units)ds.property("UNITS", 0);
            }
            if (u == null) {
                u = Units.dimensionless;
            }
        }
        AutoRangeDescriptor result = new AutoRangeDescriptor();
        if (UnitsUtil.isOrdinalMeasurement((Units)u) || UnitsUtil.isNominalMeasurement((Units)u)) {
            QDataSet ext = Ops.extent((QDataSet)ds);
            result.range = DataSetUtil.asDatumRange((QDataSet)ext, (boolean)true);
            result.robustMin = result.range.min().doubleValue(u);
            result.robustMax = result.range.max().doubleValue(u);
            logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange", ds);
            return result;
        }
        boolean mono = Boolean.TRUE.equals(ds.property("MONOTONIC"));
        if (mono) {
            mono = DataSetUtil.isMonotonicAndIncreasingQuick((QDataSet)ds);
        }
        if (null != ds.property("CADENCE") && DataSetUtil.isMonotonic((QDataSet)ds)) {
            mono = true;
        }
        if (ds.rank() != 1) {
            mono = false;
        }
        AutoRangeDescriptor typical = null;
        boolean isLog = "log".equals(ds.property("SCALE_TYPE")) && !UnitsUtil.isTimeLocation((Units)u);
        boolean bl = isLin = "linear".equals(ds.property("SCALE_TYPE")) || UnitsUtil.isTimeLocation((Units)u);
        if (!ignoreDsProps) {
            Number typicalMin = (Number)ds.property("TYPICAL_MIN");
            Number typicalMax = (Number)ds.property("TYPICAL_MAX");
            if (typicalMin != null && typicalMax != null) {
                typical = new AutoRangeDescriptor();
                typical.range = new DatumRange(typicalMin.doubleValue(), typicalMax.doubleValue(), u);
                logger1.log(Level.FINER, "use typical range: {0}", typical.range);
                typical.log = isLog;
            }
        }
        if (properties != null && "log".equals(properties.get("SCALE_TYPE")) && !UnitsUtil.isTimeLocation((Units)u)) {
            isLog = true;
        }
        if (typical == null && SemanticOps.isJoin((QDataSet)ds)) {
            result.range = null;
            result.robustMax = -1.7976931348623157E308;
            result.robustMin = Double.MAX_VALUE;
            Units units = null;
            UnitsConverter uc = UnitsConverter.IDENTITY;
            if (ds.rank() == 3) {
                for (int j = 0; j < ds.length(); ++j) {
                    QDataSet ds1 = ds.slice(j);
                    for (int i = 0; i < ds1.length(); ++i) {
                        AutoRangeDescriptor r1 = AutoRangeUtil.autoRange(ds1.slice(i), properties, false);
                        if (units == null) {
                            units = r1.range.getUnits();
                        } else {
                            uc = r1.range.getUnits().getConverter(units);
                        }
                        DatumRange datumRange = result.range = result.range == null ? r1.range : DatumRangeUtil.union((DatumRange)result.range, (DatumRange)r1.range);
                        if (!r1.log) continue;
                        result.log = true;
                    }
                }
            } else {
                for (int i = 0; i < ds.length(); ++i) {
                    AutoRangeDescriptor r1 = AutoRangeUtil.autoRange(ds.slice(i), properties, false);
                    if (units == null) {
                        units = r1.range.getUnits();
                    } else {
                        uc = r1.range.getUnits().getConverter(units);
                    }
                    DatumRange datumRange = result.range = result.range == null ? r1.range : DatumRangeUtil.union((DatumRange)result.range, (DatumRange)r1.range);
                    if (!r1.log) continue;
                    result.log = true;
                }
            }
            result.robustMin = result.range.min().doubleValue(result.range.getUnits());
            result.robustMax = result.range.max().doubleValue(result.range.getUnits());
            logger1.log(Level.FINER, "result of join autorange: {0}", result.range);
            logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange", ds);
            return result;
        }
        if (mono && ds.rank() == 1) {
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)ds, null);
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds);
            if (cadence == null || cadence.value() > 1.7976931348623156E306) {
                cadence = DRank0DataSet.create((double)0.0);
            }
            if (ds.length() > 1) {
                int lastValid;
                int firstValid;
                for (firstValid = 0; firstValid < wds.length() && wds.value(firstValid) == 0.0; ++firstValid) {
                }
                if (firstValid == wds.length()) {
                    throw new IllegalArgumentException("data contains no valid measurements");
                }
                for (lastValid = wds.length() - 1; lastValid >= 0 && wds.value(lastValid) == 0.0; --lastValid) {
                }
                if (lastValid - firstValid + 1 == 0) {
                    logger1.fine("special case where monotonic dataset contains no valid data");
                    dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
                } else {
                    double min = Math.min(ds.value(firstValid), ds.value(lastValid));
                    double max = Math.max(ds.value(firstValid), ds.value(lastValid));
                    double dcadence = Math.abs(cadence.value());
                    if (isLog) {
                        Units cu = (Units)cadence.property("UNITS");
                        if (cu == null) {
                            cu = Units.dimensionless;
                        }
                        if (UnitsUtil.isRatiometric((Units)cu)) {
                            double factor = (cu.convertDoubleTo(Units.percentIncrease, dcadence) + 100.0) / 100.0;
                            dd = new double[]{min / factor, max * factor};
                        } else if (cu.isConvertibleTo(u.getOffsetUnits())) {
                            dcadence = cu.convertDoubleTo(u.getOffsetUnits(), dcadence);
                            double[] dArray = new double[]{min - dcadence, max + dcadence};
                            dd = dArray;
                            if (dd[0] < 0.0) {
                                dd[0] = min / 2.0;
                            }
                        } else {
                            dd = new double[]{min, max};
                        }
                    } else {
                        dd = new double[]{min - dcadence, max + dcadence};
                        try {
                            logger1.log(Level.FINEST, "range of monotonic set by min to max, extended by cadence: {0}", DatumRange.newDatumRange((double)dd[0], (double)dd[1], (Units)u));
                        }
                        catch (RuntimeException cu) {}
                    }
                }
            } else if (ds.length() == 1) {
                dd = AutoRangeUtil.simpleRange(ds);
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{dd[0], dd[0] + Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{dd[0], dd[0] + 1.0};
            } else {
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
        } else {
            try {
                dd = AutoRangeUtil.simpleRange(ds);
                logger1.log(Level.FINEST, "simpleRange(ds)= {0} - {1}", new Object[]{dd[0], dd[1]});
                if (Units.dimensionless.isFill(dd[0])) {
                    dd[0] = dd[0] / 100.0;
                }
                if (Units.dimensionless.isFill(dd[1])) {
                    dd[1] = dd[1] / 100.0;
                }
            }
            catch (IllegalArgumentException ex) {
                logger1.log(Level.WARNING, ex.getMessage(), ex);
                dd = UnitsUtil.isTimeLocation((Units)u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
        }
        if (UnitsUtil.isTimeLocation((Units)u) && dd[0] == dd[1]) {
            if (dd[0] <= -1.0E29) {
                throw new IllegalArgumentException("timetags are all invalid ");
            }
            Units du = u.getOffsetUnits();
            double d = Units.days.convertDoubleTo(du, 1.0);
            dd[0] = Math.floor(dd[0] / d) * d;
            dd[1] = dd[0] + d;
        }
        boolean isHist = false;
        if (dd[0] == dd[1]) {
            if (dd[0] == 0.0) {
                dd[0] = -1.0;
                dd[1] = 1.0;
            } else if (dd[0] > 0.0) {
                dd[0] = 0.0;
            } else {
                dd[1] = 0.0;
            }
            median = (dd[0] + dd[1]) / 2.0;
            positiveMin = dd[0] + (dd[1] - dd[0]) * 0.1;
            total = ds.length();
        } else {
            isHist = "stairSteps".equals(ds.property("RENDER_TYPE"));
            double binSize = (dd[1] - dd[0]) * 0.01;
            QDataSet hist = DataSetOps.histogram((QDataSet)ds, (double)(dd[0] - binSize / 2.0), (double)(dd[1] + binSize / 2.0), (double)((dd[1] - dd[0]) / 100.0));
            positiveMin = (Double)hist.property("positiveMin");
            total = 0;
            for (int i = 0; i < hist.length(); ++i) {
                total = (int)((double)total + hist.value(i));
            }
            median = u.getFillDouble();
            int total50 = 0;
            for (int i = 0; i < hist.length(); ++i) {
                if ((total50 = (int)((double)total50 + hist.value(i))) < total / 2) continue;
                median = ((QDataSet)hist.property("DEPEND_0")).value(i);
                break;
            }
        }
        if (total < 3) {
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (UnitsUtil.isTimeLocation((Units)u)) {
                double dmin = TimeUtil.createTimeDatum((int)1000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                double dmax = TimeUtil.createTimeDatum((int)9000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                if (result.robustMin > dmax) {
                    result.robustMin = dmax;
                }
                if (result.robustMin < dmin) {
                    result.robustMin = dmin;
                }
                if (result.robustMax > dmax) {
                    result.robustMax = dmax;
                }
                if (result.robustMax < dmin) {
                    result.robustMax = dmin;
                }
            }
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        } else {
            double nomMax;
            double nomMin;
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (mono) {
                nomMin = ds.value(0);
                nomMax = ds.value(ds.length() - 1);
            } else {
                nomMin = dd[0];
                nomMax = dd[1];
            }
            double clin = (nomMax - result.median) / (result.median - nomMin);
            if (clin > 1.0) {
                clin = 1.0 / clin;
            }
            if (!isLin && result.median > 0.0 && !UnitsUtil.isTimeLocation((Units)u)) {
                double clog = nomMax / result.median / Math.abs(result.median / nomMin);
                if (clog > 1.0) {
                    clog = 1.0 / clog;
                }
                if (clog > clin && nomMax / nomMin > 100.0) {
                    isLog = true;
                }
            }
            if (!isLin && !isHist && result.median == 0.0 && nomMin == 0.0 && nomMax / positiveMin > 1000.0) {
                isLog = true;
                result.robustMin = positiveMin / 10.0;
            }
            if (UnitsUtil.isTimeLocation((Units)u)) {
                double dmin = TimeUtil.createTimeDatum((int)1000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                double dmax = TimeUtil.createTimeDatum((int)9000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0).doubleValue(u);
                if (result.robustMin > dmax) {
                    result.robustMin = dmax;
                }
                if (result.robustMin < dmin) {
                    result.robustMin = dmin;
                }
                if (result.robustMax > dmax) {
                    result.robustMax = dmax;
                }
                if (result.robustMax < dmin) {
                    result.robustMax = dmin;
                }
            }
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
        }
        logger1.log(Level.FINE, "result.range at this point is {0} {1} {2}", new Object[]{result.range, result.range.getUnits(), result.robustMin});
        result.log = isLog;
        if (properties != null) {
            Number tmin = (Number)properties.get("TYPICAL_MIN");
            Number tmax = (Number)properties.get("TYPICAL_MAX");
            Units uu = (Units)properties.get("UNITS");
            if (uu == null) {
                uu = Units.dimensionless;
            }
            logger1.log(Level.FINER, "from properties: typical: {0} {1} \"{2}\"", new Object[]{tmin, tmax, uu});
            if (UnitsUtil.isTimeLocation((Units)u)) {
                uu = u;
            }
            if (UnitsUtil.isIntervalOrRatioMeasurement((Units)uu)) {
                Datum ftmin = uu.createDatum(tmin == null ? (Number)-1.7976931348623157E308 : (Number)tmin);
                logger1.log(Level.FINER, "isLog={0} ftmin={1} tmin={2} tmax={3} uu={4}", new Object[]{isLog, ftmin, tmin, tmax, uu});
                if (isLog && tmin != null && tmin.doubleValue() <= 0.0) {
                    tmin = tmax.doubleValue() / 10000.0;
                }
                if (tmin != null && tmax != null) {
                    double d2;
                    double d1;
                    DatumRange range = AutoRangeUtil.getRange(tmin, tmax, uu);
                    logger1.log(Level.FINER, "getRange from typical: {0}", new Object[]{range});
                    if (result.log) {
                        if (ftmin.doubleValue(uu) <= 0.0) {
                            ftmin = uu.createDatum(1.0E-38);
                        }
                        Datum limit = ftmin;
                        try {
                            Datum dd1 = result.range.min().ge(limit) ? result.range.min() : limit;
                            Datum dd2 = result.range.max().ge(limit) ? result.range.max() : limit;
                            d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                            d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                        }
                        catch (InconvertibleUnitsException ex) {
                            range = AutoRangeUtil.makeDimensionless(range);
                            result.range = AutoRangeUtil.makeDimensionless(result.range);
                            Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                            Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                            d1 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd1);
                            d2 = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)dd2);
                        }
                        if (d2 > 1.2 && d2 < 2.0) {
                            logger1.log(Level.FINE, "TYPICAL_MAX rejected because max ({0}) outside the value of TYPICAL range ({1})", new Object[]{result.range.max(), range});
                            range = DatumRangeUtil.rescaleLog((DatumRange)range, (double)0.0, (double)1.333);
                            DatumRange range2 = DatumRangeUtil.rescaleLog((DatumRange)range, (double)0.0, (double)2.0);
                            d2 /= 1.333;
                            d1 /= 1.333;
                            logger1.fine("adjusting TYPICAL_MAX from metadata, multiply by 1.2");
                            if (d2 > 1.2 && d2 < 2.0) {
                                range = range2;
                                d2 = d2 * 1.333 / 2.0;
                                d1 = d1 * 1.333 / 2.0;
                                logger1.fine("adjusting TYPICAL_MAX from metadata, multiply by 2.0");
                            }
                        }
                        if (d1 < -4.0 && d2 > 0.0) {
                            logger1.fine("rejecting statistical range because min is too small.");
                            result.range = range;
                            result.robustMin = range.min().doubleValue(result.range.getUnits());
                            result.robustMax = range.max().doubleValue(result.range.getUnits());
                            d1 = 0.0;
                            d2 = 1.0;
                        }
                    } else {
                        try {
                            d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                            d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                        }
                        catch (InconvertibleUnitsException ex) {
                            range = AutoRangeUtil.makeDimensionless(range);
                            result.range = AutoRangeUtil.makeDimensionless(result.range);
                            d1 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.min());
                            d2 = DatumRangeUtil.normalize((DatumRange)range, (Datum)result.range.max());
                        }
                        if (d2 > 1.2 && d2 < 2.0) {
                            range = DatumRangeUtil.rescale((DatumRange)range, (double)0.0, (double)2.0);
                            d2 /= 2.0;
                            d1 /= 2.0;
                            logger1.fine("adjusting TYPICAL_MAX from metadata, multiply by 2.0");
                        }
                    }
                    logger1.log(Level.FINER, "possible range 854: {0}", range);
                    if (d2 - d1 > 0.1 && d2 > 0.0 && d2 < 1.14 && d1 > -0.1 && d1 < 1.0 && uu.isConvertibleTo(u)) {
                        result.range = range;
                        logger1.fine("using TYPICAL_MIN, TYPICAL_MAX from metadata");
                        logger1.log(Level.FINE, "autorange {0} -> {1} (exit1)", new Object[]{ds, result.range});
                        logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange", result.range);
                        return result;
                    }
                    logger1.log(Level.FINE, "TYPICAL_MIN={0} and TYPICAL_MAX={1} from metadata rejected because it clipped or squished the data {2}", new Object[]{tmin.toString(), tmax.toString(), result.range});
                }
            }
        }
        if (UnitsUtil.isIntervalOrRatioMeasurement((Units)u)) {
            if (result.log) {
                if (result.robustMax <= 0.0 || Double.isNaN(result.robustMax)) {
                    result.robustMax = 1000.0;
                }
                if (result.robustMin <= 0.0 || Double.isNaN(result.robustMin)) {
                    result.robustMin = result.robustMax / 1000.0;
                }
                Datum min = u.createDatum(result.robustMin);
                Datum max = u.createDatum(result.robustMax);
                logger1.log(Level.FINER, "domain divider at 866: {0} {1}", new Object[]{min, max});
                DomainDivider div = DomainDividerUtil.getDomainDivider((Datum)min, (Datum)max, (boolean)true);
                while (div.boundaryCount(min, max) > 40L) {
                    div = div.coarserDivider(false);
                }
                while (div.boundaryCount(min, max) < 20L) {
                    div = div.finerDivider(true);
                }
                DatumRange rmin = div.rangeContaining(min);
                DatumRange rmax = div.rangeContaining(max);
                result.range = new DatumRange(rmin.min(), rmax.max());
            } else if (UnitsUtil.isTimeLocation((Units)u)) {
                if (result.range.min().doubleValue((Units)Units.us2000) > -6.311348E15) {
                    logger1.log(Level.FINER, "entering domain divider bit: {0}", result.range);
                    if (result.range.width().value() == 0.0) {
                        result.range = new DatumRange(result.range.min(), result.range.min().add(Units.seconds.createDatum(1)));
                    } else {
                        DomainDivider div = DomainDividerUtil.getDomainDivider((Datum)result.range.min(), (Datum)result.range.max());
                        while (div.boundaryCount(result.range.min(), result.range.max()) > 40L) {
                            div = div.coarserDivider(false);
                        }
                        while (div.boundaryCount(result.range.min(), result.range.max()) < 20L) {
                            div = div.finerDivider(true);
                        }
                        logger1.log(Level.FINER, "domainDivider selected: {0} {1}", new Object[]{div, result.range.getUnits()});
                        Datum resultmin = result.range.min();
                        logger1.log(Level.FINER, "result.range.min(): {0} {1}", new Object[]{String.format("%20f", resultmin.doubleValue(resultmin.getUnits())), resultmin.getUnits()});
                        DatumRange rmin = div.rangeContaining(result.range.min());
                        logger1.log(Level.FINER, "rmin: {0} {1}", new Object[]{rmin, rmin.getUnits()});
                        logger1.log(Level.FINER, "result.range.min(): {0} {1}", new Object[]{result.range.min(), result.range.min().getUnits()});
                        logger1.log(Level.FINER, "range.max-rmin: {0}", rmin.max().subtract(result.range.min()));
                        logger1.log(Level.FINER, "div.rangeContaining units: {0}", rmin.getUnits());
                        DatumRange rmax = div.rangeContaining(result.range.max());
                        logger1.log(Level.FINER, "min: {0}, range containing min: {1}", new Object[]{result.range.min(), rmin});
                        logger1.log(Level.FINER, "max: {0}, range containing max: {1}", new Object[]{result.range.max(), rmax});
                        result.range = new DatumRange(rmin.min(), rmax.max());
                    }
                }
                logger1.log(Level.FINER, "range at 909: {0}", result.range);
            } else {
                result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
                if (result.robustMin < result.robustMax) {
                    result.range = DatumRangeUtil.rescale((DatumRange)result.range, (double)-0.05, (double)1.05);
                }
                if (result.robustMin == 0.0 && result.robustMax == 0.0) {
                    result.range = DatumRange.newDatumRange((double)-0.1, (double)1.0, (Units)u);
                }
                logger1.log(Level.FINER, "range at 918: {0}", result.range);
            }
        } else {
            result.range = DatumRange.newDatumRange((double)result.robustMin, (double)result.robustMax, (Units)u);
            logger1.log(Level.FINER, "range based on robustMin and robustMax: {0}", result.range);
        }
        if (typical != null) {
            double overlap;
            logger1.finer("checking typical");
            if (result.log && typical.log) {
                double overlap2;
                if (typical.range.min().doubleValue(typical.range.getUnits()) <= 0.0) {
                    Datum d10 = typical.range.max().divide(10.0);
                    Datum m = result.range.min().le(d10) ? result.range.min() : d10;
                    typical.range = new DatumRange(m, typical.range.max());
                }
                if (result.range.intersects(typical.range) && (overlap2 = DatumRangeUtil.normalizeLog((DatumRange)result.range, (Datum)typical.range.max()) - DatumRangeUtil.normalizeLog((DatumRange)result.range, (Datum)typical.range.min())) > 0.01 && overlap2 < 100.0) {
                    logger1.log(Level.FINE, "autorange {0} -> {1} (exit2)", new Object[]{ds, result.range});
                    logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange", result.range);
                    return typical;
                }
            } else if (!typical.log && result.range.intersects(typical.range) && (overlap = DatumRangeUtil.normalize((DatumRange)result.range, (Datum)typical.range.max()) - DatumRangeUtil.normalize((DatumRange)result.range, (Datum)typical.range.min())) > 0.01 && overlap < 100.0) {
                logger1.log(Level.FINE, "autorange {0} -> {1} (exit3)", new Object[]{ds, result.range});
                logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange", result.range);
                return typical;
            }
        }
        logger1.log(Level.FINE, "autorange {0} -> {1}", new Object[]{ds, result.range});
        logger1.exiting("org.autoplot.AutoRangeUtil", "autoRange", result.range);
        return result;
    }

    public static class AutoRangeDescriptor {
        public DatumRange range;
        public boolean log;
        private double robustMin;
        private double robustMax;
        private double median;

        public String toString() {
            return "" + this.range + " " + (this.log ? "log" : "");
        }
    }
}

